#!/bin/bash -
# Script used to link OCaml programs.
# ocaml-link.sh.  Generated from ocaml-link.sh.in by configure.
# (C) Copyright 2015-2025 Red Hat Inc.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

# See guestfs-hacking(1) section "HOW OCAML PROGRAMS ARE COMPILED AND LINKED"

# Hack automake to link OCaml-based binaries properly.
# There is no other way to add the -cclib parameter to the end of
# the command line.

# Usage:
#   ./ocaml-link.sh -cclib '...' -- ARGS
# Pass the cclib argument separately, and the rest as separated
# arguments.

cclib=

while true ; do
  case "$1" in
    -cclib|--cclib) cclib="$2" ; shift 2 ;;
    -cclib=*|--cclib=*) cclib="${1#*=}"; shift 1 ;;
    --) shift ; break ;;
    *)
        printf >&2 "usage: %s [-cclib lib] -- arg ...\n" "$(basename "$0")"
        exit 2 ;;
  esac
done

# Without this, if we use `libguestfs/run` while `ocaml-libguestfs-*`
# host packages are installed, we get mismatched search path warnings
# like these, and then linking fails:
#
#  findlib: [WARNING] Package guestfs has multiple definitions in /tmp/libguestfs.git/ocaml/guestfs/META, /usr/lib64/ocaml/guestfs/META
#  findlib: [WARNING] Interface guestfs.cmi occurs in several directories: /usr/lib64/ocaml/guestfs, /tmp/libguestfs.git/ocaml/guestfs
guestfs_path=$(ocamlfind query guestfs 2>/dev/null)

# Integration with silent rules of automake: print the full command
# line option in verbose mode.
if [ x"${V:-0}" = x1 ]; then
  echo "$@" \
     -runtime-variant _pic \
     -I "$guestfs_path" \
     -linkpkg \
     -cclib "'-Wl,-z,relro -Wl,--as-needed  -Wl,-z,pack-relative-relocs -Wl,-z,now -specs=/usr/lib/rpm/redhat/redhat-hardened-ld -specs=/usr/lib/rpm/redhat/redhat-hardened-ld-errors -specs=/usr/lib/rpm/redhat/redhat-annobin-cc1  -Wl,--build-id=sha1    $cclib'"
fi
# NB -cclib must come last.
exec "$@" \
     -runtime-variant _pic \
     -I "$guestfs_path" \
     -linkpkg \
     -cclib "-Wl,-z,relro -Wl,--as-needed  -Wl,-z,pack-relative-relocs -Wl,-z,now -specs=/usr/lib/rpm/redhat/redhat-hardened-ld -specs=/usr/lib/rpm/redhat/redhat-hardened-ld-errors -specs=/usr/lib/rpm/redhat/redhat-annobin-cc1  -Wl,--build-id=sha1    $cclib"
