(* virt-v2v
 * Copyright (C) 2009-2025 Red Hat Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 *)

type options = {
  block_driver : Types.guestcaps_block_type; (** [--block-driver] option *)
  keep_serial_console : bool;
  ks : Tools_utils.key_store;      (** [--key] option *)
  memsize : int option;            (** [--memsize] option *)
  network_map : Networks.t;        (** [-b] and [-n] options *)
  root_choice : Types.root_choice; (** [--root] option *)
  smp : int option;                (** [--smp] option *)
  static_ips : Types.static_ip list; (** [--mac :ip:] option *)
  customize_ops : Customize_cmdline.ops; (** virt-customize options *)
}
(** Command line options that get passed through to the conversion code. *)

val convert : NBD_URI.t list -> options -> Types.source ->
              Types.inspect * Types.target_meta
(** The function that is called from virt-v2v to perform the actual
    conversion of a guest to run on KVM.

    The first parameter is the list of disks (as NBD URIs).

    As a side-effect of conversion we inspect the guest, so this
    function returns the inspection data, as well as the target
    metadata determined by the conversion process. *)
